﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Linq;
using System.ServiceProcess;
using System.Text;
using System.Net.Sockets;
using System.Net;
using System.Threading;

namespace MoneyServer
{
    public partial class Service1 : ServiceBase
    {
        private TcpListener m_tcpl;
        private bool m_stopping;

        public Service1()
        {
            InitializeComponent();
        }

        /// <summary>
        /// uruchomienie nasłuchiwania żądań do usługi MoneyServer 
        /// </summary>
        /// <param name="args">nie używany</param>
        protected override void OnStart(string[] args)
        {
            const int Port = 2010;

            var ipAddr = new IPAddress(
                new byte[] { 127, 0, 0, 1 });

            m_tcpl = new TcpListener(ipAddr, Port);
            m_tcpl.Start();

            new Thread(
                () => ListenForQuoteRequests())
                .Start();
        }

        /// <summary>
        /// uruchomienie nasłuchiwania żądań
        /// </summary>
        private void ListenForQuoteRequests()
        {
            const int StreamSize = 256;

            Random rnd = null;
            string reqString = string.Empty;
            int index = 0;

            var talk = new List<string>
            {
"Ziarnko do ziarnka a zbierze się miarka",
"Grosz oszczędzony przerabia się w miliony",
"Do grosza grosz, to napełni się trzos"

            };

            var AsciiEnc = new ASCIIEncoding();
            var inStream = new byte[StreamSize];
            var outStream = new byte[StreamSize];

            while (!m_stopping)
            {
                try
                {
                    Socket sock = m_tcpl.AcceptSocket();

                    int count = sock.Receive(
                        inStream, inStream.Length, 0);
                    reqString = AsciiEnc.GetString(
                        inStream, 0, count);

                    Console.WriteLine(reqString);

                    rnd = new Random();
                    index = rnd.Next(talk.Count);

                    outStream = AsciiEnc.GetBytes(
                        talk[index] as string);

                    sock.Send(outStream, outStream.Length, 0);
                }
                catch (SocketException sockEx)
                {
                    Console.WriteLine(
                    "Wystąpił błąd: {0}",
                    sockEx.ToString());
                } 
            }
        }

        /// <summary>
        /// zatrzymanie nasłuchiwania 
        /// </summary>
        protected override void OnStop()
        {
            m_stopping = true;
            m_tcpl.Stop();
        }
    }
}
